/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.block.entity.theme;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.respawnobelisks.config.ChargeConfig;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBER;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.registry.block.entity.theme.BasicDepleteAnimation;
import com.redpxnda.respawnobelisks.registry.block.entity.theme.NamedRenderTheme;
import com.redpxnda.respawnobelisks.util.RenderUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

@FunctionalInterface
public interface RenderTheme {
    public static final Random rdm;

    public static void init() {
        RenderTheme.register(NamedRenderTheme.of("defaultCharge", (be, pt, ps, bs, pl, po) -> {
            Minecraft mc;
            Level level = be.m_58904_();
            if (level == null || (mc = Minecraft.m_91087_()) == null) {
                return;
            }
            BlockPos pos = be.m_58899_();
            if (mc.f_91074_ != null) {
                HitResult patt1750$temp;
                if (rdm.nextDouble() > 0.8 && (patt1750$temp = mc.f_91077_) instanceof BlockHitResult) {
                    BlockHitResult bhr = (BlockHitResult)patt1750$temp;
                    if ((be.m_58899_().equals((Object)bhr.m_82425_()) || be.m_58899_().equals((Object)bhr.m_82425_().m_7495_())) && ChargeConfig.getChargeItems().containsKey(mc.f_91074_.m_21205_().m_41720_())) {
                        RenderTheme.tickLoopedExecution(be, "defaultCharge", blockEntity -> {
                            if (be.getLastCharge() < level.m_46467_() - 50L) {
                                double rX = rdm.nextDouble(6.0) - 3.0;
                                double rZ = rdm.nextDouble(6.0) - 3.0;
                                level.m_7106_((ParticleOptions)ModRegistries.CHARGE_INDICATOR_PARTICLE.get(), (double)pos.m_123341_() + 0.5 + rX, (double)pos.m_123342_() + rdm.nextDouble(1.75), (double)pos.m_123343_() + 0.5 + rZ, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                            }
                        });
                    }
                }
                ps.m_85836_();
                VertexConsumer vc = bs.m_6299_(RenderType.m_110504_());
                RenderUtils.CHARGE_PARTICLES.get((Object)pos).forEach(particle -> {
                    vc.m_85982_(ps.m_85850_().m_85861_(), 0.5f, (float)(particle.getY() - (double)pos.m_123342_()), 0.5f).m_85950_(1.0f, 1.0f, 1.0f, particle.alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    vc.m_85982_(ps.m_85850_().m_85861_(), (float)(particle.getX() - (double)pos.m_123341_()), (float)(particle.getY() - (double)pos.m_123342_()), (float)(particle.getZ() - (double)pos.m_123343_())).m_85950_(1.0f, 1.0f, 1.0f, particle.alpha).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                });
                ps.m_85849_();
            }
            RenderTheme.timedExecution(be, be.getLastCharge(), "defaultCharge-main", x -> {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123747_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Registry.f_122821_.m_6612_(new ResourceLocation(ChargeConfig.obeliskChargeSound)).orElse(SoundEvents.f_12490_), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            });
        }));
        RenderTheme.register(new BasicDepleteAnimation("defaultDeplete", be -> {
            Level level = be.m_58904_();
            BlockPos pos = be.m_58899_();
            if (!1.$assertionsDisabled && level == null) {
                throw new AssertionError((Object)" Level is somehow null in BasicDepleteAnimation");
            }
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Registry.f_122821_.m_6612_(new ResourceLocation(ChargeConfig.obeliskDepleteSound)).orElse(SoundEvents.f_12490_), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            level.m_7106_((ParticleOptions)ModRegistries.DEPLETE_RING_PARTICLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.05, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }));
        RenderTheme.register(NamedRenderTheme.of("defaultRunes", (be, pt, ps, bs, pl, po) -> {
            if (RespawnObeliskBER.SPRITE == null) {
                RespawnObeliskBER.SPRITE = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(RespawnObeliskBER.RUNES);
            }
            RenderUtils.renderRunes(RespawnObeliskBER.SPRITE, be, pt, ps, bs, pl);
        }));
    }

    public static void register(NamedRenderTheme theme) {
        NamedRenderTheme.THEMES.put(theme.getName(), theme);
    }

    public static void register(NamedRenderTheme theme, String name) {
        NamedRenderTheme.THEMES.put(name, theme);
    }

    public static void timedExecution(RespawnObeliskBlockEntity blockEntity, long checkAgainst, String name, BlockEntityOnly handler, BlockEntityOnly ifFailed) {
        long gameTime = blockEntity.getGameTime();
        float renderProgress = blockEntity.themeData.get(name);
        if (gameTime - 3L <= checkAgainst && renderProgress < 1.0f) {
            handler.call(blockEntity);
            blockEntity.themeData.put(name, 1.0f);
        } else if (gameTime - 3L > checkAgainst && renderProgress >= 1.0f) {
            blockEntity.themeData.put(name, 0.0f);
            ifFailed.call(blockEntity);
        }
    }

    public static void timedExecution(RespawnObeliskBlockEntity blockEntity, long checkAgainst, String name, BlockEntityOnly handler) {
        RenderTheme.timedExecution(blockEntity, checkAgainst, name, handler, be -> {});
    }

    public static void tickLoopedExecution(RespawnObeliskBlockEntity blockEntity, String name, BlockEntityOnly handler) {
        long checkAgainst;
        long gameTime = blockEntity.getGameTime();
        if (gameTime != (checkAgainst = blockEntity.themeData.getLong(name))) {
            handler.call(blockEntity);
            blockEntity.themeData.putLong(name, gameTime);
        }
    }

    public void render(RespawnObeliskBlockEntity var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        rdm = new Random();
    }

    @FunctionalInterface
    public static interface BlockEntityOnly
    extends RenderTheme {
        public void call(RespawnObeliskBlockEntity var1);

        @Override
        default public void render(RespawnObeliskBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
            this.call(blockEntity);
        }
    }
}

